timestartdisp=time(1);
fig1=figure('Name',['Wind Profiles for  ',datestr(time(1),'mm/dd/yy')],'Position',[50 50 1400 400]);

%subplot(4,1,1)
colormap(jet(1064))
hax1=axes('YLim',[0 500])
hold on
paxe=pcolor(haxe,time-time(1),height,turb);
set(paxe,'EdgeColor','none')
title(['Turbulence for ',datestr(time(1),'mm/dd/yy')],'FontSize',14,'FontWeight','bold')
view(0,90)
colorbar
caxis([0 .5])
datetick('x',15)
ylabel('Height AGL (m)','FontSize',14)
xlabel('Time of Day (UTC)','FontSize',14)
% h=text(1.0,1.2,{['Wind Conditions for period ',num2str(periodnum)];period_start}, ...
%     'Units','normalized','FontWeight','bold','HorizontalAlignment','right')
%set(haxe,'BackgroundColor',[.6 .6 .6])

subplot(4,1,2)
haxe2=pcolor(time-timestartdisp,height,theta);
set(haxe2,'EdgeColor','none')
view(0,90)
colorbar
ylim([0 500])
colormap(jet(64))
caxis([0 360])
datetick('x',15)

ylabel('Height AGL (m)')
xlabel('Direction (degrees)')


subplot(4,1,3)
time_lidar=timestartdisp+Tbar/24;
surf(time_lidar,R,zeros(size(ubar')),specwidthbar','EdgeColor','none')
view(0,90)
colorbar
hold
plot(timestartdisp+Tbar_p/24,Hbar,'k','Linewidth',2)
ylim([0 (max(Hbar)+.5)])
colormap(jet(64))
caxis([0 3])
datetick('x',15)
xlim([min(timestartdisp+Tbar_p/24),max(timestartdisp+Tbar_p/24)])

ylabel('Height AGL (Kft)')
xlabel('Time')
title('Turbulence Estimate (kts)')

subplot(4,1,4)
time_lidar=timestartdisp+Tbar/24;
surf(time_lidar,R,zeros(size(ubar')),theta','EdgeColor','none')
view(0,90)
colorbar
hold
plot(timestartdisp+Tbar_p/24,Hbar,'k','Linewidth',2)
ylim([0 (max(Hbar)+.5)])
colormap(jet(64))
caxis([0 360])

datetick('x',15)
xlim([min(timestartdisp+Tbar_p/24),max(timestartdisp+Tbar_p/24)])

ylabel('Height AGL (Kft)')
xlabel('Time')
title('Wind Direction')

